clear all

* Set folder

cd ..\Outputs

use SEMESTER, clear

keep if ISO=="USA"
keep year semester tt GPIMFtp0gtm0 GPOECtp0gtm0 GYCOCtp7gtm0

rename GPIMFtp0gtm0 gRpIMF
replace gRpIMF=gRpIMF*100
rename GPOECtp0gtm0 gRpOEC
replace gRpOEC=gRpOEC*100
rename GYCOCtp7gtm0 gRpCON

cd ..\Inputs

merge 1:1 year semester using USACBO
capture drop _merge
merge 1:1 year semester using USAGRE
capture drop _merge

drop if gRpIMF==. & gRpOEC==. & gRpCON==. & gRpCBO==. & gRpGRE==.

gen yearsem=year+(sem-1)/2

twoway ///
(scatter gRpIMF yearsem, msize(1.2) connect(direct) mcolor(red) mfcolor(white) lcolor(red) lpattern(solid))  ///
(line gRpOEC yearsem, lcolor(blue) )  ///
(line gRpCON yearsem, lcolor(dkorange) lpattern(shortdash) lwidth(medthick))  ///
(line gRpCBO yearsem, lcolor(black) lwidth(thick) )  ///
(line gRpGRE yearsem, lcolor(green) lpattern(longdash)), ///
xtitle("") xlabel(1987(4)2016) ///
ytitle("Growth rate of potential output (annualized %)") ylabel(1(0.5)5.5) ///
legend(	label(1 "IMF") label(2 "OECD") label(3 "Consensus") ///
		label(4 "CBO") label(5 "Greenbook") ring(0) position(1) rows(2)) ///
graphregion(color(white)) bgcolor(white)
